<?php
/*
Plugin Name: fuwari
Description: フワッと表示するプラグインだよ
Version: 1.0
*/

if(! defined('ABSPATH') ) exit;//phpファイルのURLに直接アクセスされても中身見られないようにする記述

// ★フック関数の基本★
// function 呼び出してほしい関数名() {
//     echo '呼び出してほしい関数名で出力したい内容';
// }
// add_action( 'フックさせたい場所の名前', '呼び出してほしい関数名' );

define('FUWARI_VERSION', '1,0');
define('PLUGIN_PATH', plugin_dir_path(__FILE__));
define('PLUGIN_URL', plugins_url('/',__FILE__));

// ↓PLUGIN_PATH
// /★★★WordPressが置いてある場所までのパス★★★/wp-content/plugins/fuwari/
// ↓PLUGIN_URL
// https://wp.notosaku.net/wp-content/plugins/fuwari/

/* CSSとJSの読み込み */

add_action( 'wp_enqueue_scripts', function(){ //アクションフック（特定のタイミングで独自の処理をさせる事ができる仕組み）、wp_enqueue_scripts→スクリプトとスタイルを読み込む場所
    /* JS */
    wp_deregister_script('jquery');//デフォルトのjQueryを削除

    wp_enqueue_script(//指定のjQuery追加
        'jquery',
        '//code.jquery.com/jquery-3.6.0.min.js',
        '',
        '',
        true
    );

    wp_enqueue_script(
        'fuwari-script', //識別名（ハンドル名）
        PLUGIN_URL.'assets/fuwari.js', //読み込むファイルのパス
        array('jquery'), //依存するスクリプト
        FUWARI_VERSION, //スクリプトのバージョン
        true //読み込む場所
    );

    /* CSS */
    wp_enqueue_style(
        'fuwari-style', //識別名（ハンドル名）
        PLUGIN_URL.'assets/fuwari.css', //読み込むファイルのパス
        array(), //依存するスクリプト
        FUWARI_VERSION //スクリプトのバージョン
    );

} );

/*
■使い方
スクロールしたら作動するクラス
.js-fadeup
.js-fade

ローディングしたら作動するクラス
.js-load-fade
.js-load-fadeup

補助クラス
.dur100　～　.dur2000(animation-duration　0.1s　～　2s)
.delay500　～　.delay2000(animation-delay　0.5s　～　3s)※500ごと用意

動きをつけたいものにクラスをつける
補助クラスで多少動きの制御が可能
*/